package cn.yoofans.knowledge.center.api.remoteservice.test;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.test.BucketWhitelistDTO;

import java.util.List;

/**
 * 测试计划分桶白名单远程接口
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteBucketWhitelistService {

    /**
     * 依据id查询数据
     *
     * @param id
     * @return
     */
    BucketWhitelistDTO findOneById(Long id);

    /**
     * 依据bucketId查询数据
     *
     * @param bucketId
     * @return
     */
    BucketWhitelistDTO findOneByBucketId(Long bucketId);

    /**
     * 依据planId查询数据
     *
     * @param planId
     * @return
     */
    List<BucketWhitelistDTO> findListByPlanId(Long planId);

    /**
     * 依据planId查询数据
     *
     * @param planId
     * @param bucketId
     * @return
     */
    BucketWhitelistDTO findOneByPlanIdAndBucketId(Long planId, Long bucketId);

}
