package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.coupon.ActivityAwardDTO;

import java.util.List;

/**
 * 活动奖励接口
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteActivityAwardService {

    /**
     * 保存数据
     *
     * @param activityAwardDTO
     * @return
     */
    Boolean insert(ActivityAwardDTO activityAwardDTO);

    /**
     * 批量保存数据
     *
     * @param awards
     * @return
     */
    Boolean batchInsert(List<ActivityAwardDTO> awards);

    /**
     * 依据activityId删除数据
     *
     * @param activityId
     * @return
     */
    Boolean deleteByActivityId(Long activityId);

    /**
     * 依据活动Id查询活动奖励信息
     *
     * @param activityId
     * @return
     */
    List<ActivityAwardDTO> selectByActivityId(Long activityId);
}
