package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.coupon.ActivityDTO;
import cn.yoofans.knowledge.center.api.param.coupon.ActivityPageQueryParams;
import org.springframework.data.domain.PageImpl;

/**
 * 活动接口
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteActivityService {

    /**
     * 保存数据
     *
     * @param activityDTO
     * @return
     */
    ActivityDTO insert(ActivityDTO activityDTO);

    /**
     * 依据id删除数据
     *
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 修改数据
     *
     * @param activityDTO
     * @return
     */
    Boolean update(ActivityDTO activityDTO);

    /**
     * 依据id查询数据
     *
     * @param id
     * @return
     */
    ActivityDTO selectById(Long id);

    /**
     * 依据activityId查询数据
     *
     * @param activityId
     * @return
     */
    ActivityDTO selectByActivityId(String activityId);

    /**
     * 依据activityId和status查询数据
     *
     * @param activityId
     * @param status
     * @return
     */
    ActivityDTO selectByActivityIdAndStatus(String activityId, Integer status);

    /**
     * 分页查询数据
     *
     * @param pageQueryParam
     * @return
     */
    PageImpl<ActivityDTO> findPageList(ActivityPageQueryParams pageQueryParam);

    /**
     * 修改活动状态
     *
     * @param id
     * @param activityStatus
     * @return
     */
    Boolean updateStatus(Long id, Integer activityStatus);

}
