package cn.yoofans.knowledge.center.api.remoteservice.test;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.test.TestPlanDTO;
import cn.yoofans.knowledge.center.api.param.test.TestPlanPageQryParams;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * 测试计划远程接口
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteTestPlanService {

    /**
     * 保存数据
     *
     * @param plan
     * @return
     */
    TestPlanDTO save(TestPlanDTO plan) throws BizException;

    /**
     * 依据id删除数据
     *
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 修改数据
     *
     * @param plan
     * @return
     */
    Boolean update(TestPlanDTO plan) throws BizException;

    /**
     * 修改状态
     *
     * @param id
     * @param status
     * @return
     */
    Boolean updateStatus(Long id, Integer status);

    /**
     * 分页查询数据
     *
     * @param params
     * @return
     */
    PageImpl<TestPlanDTO> findPageList(TestPlanPageQryParams params);

    /**
     * 依据id查询数据
     *
     * @param id
     * @return
     */
    TestPlanDTO selectById(Long id);

    /**
     * 依据abtestId查询数据
     *
     * @param abTestId
     * @return
     */
    TestPlanDTO selectByAbTestId(String abTestId);

    /**
     * @param title
     * @return
     */
    List<TestPlanDTO> findListByTitle(String title);

}
