package cn.yoofans.knowledge.center.api.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

/**
 * Created by zhangshun on 2018/5/25,09:08:40.
 */
public class ReadDayUtils {

    public static String diffDate(Date date) {

        Calendar today = Calendar.getInstance();

        if (StringUtils.equals(DateFormatUtils.format(date, "yyyyMMdd"), DateFormatUtils.format(today, "yyyyMMdd"))) {
            return "today";
        }

        today.set(Calendar.HOUR, 0);
        today.set(Calendar.MINUTE, 0);
        today.set(Calendar.SECOND, 0);
        today.set(Calendar.MILLISECOND, 0);

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        if (today.before(calendar)) {
            return "future";
        }
        return "before";
    }

    /**
     * 已开课几天
     *
     * @param beginDate
     * @param clockDate
     * @return
     */
    public static Integer getReadPastDays(Date beginDate, Date clockDate) {

        if (Objects.isNull(beginDate)) {
            throw new RuntimeException("开课日期错误");
        }

        if (Objects.isNull(clockDate)) {
            throw new RuntimeException("打卡日期错误");
        }

        LocalDate begin = beginDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        LocalDate end = clockDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        return Math.abs((int) ((end.toEpochDay() - begin.toEpochDay()) + 1));
    }

    /**
     * 还要几天开课
     *
     * @param beginDate
     * @param clockDate
     * @return
     */
    public static Integer getReadAfterDays(Date beginDate, Date clockDate) {

        if (Objects.isNull(beginDate)) {
            throw new RuntimeException("开课日期错误");
        }

        if (Objects.isNull(clockDate)) {
            throw new RuntimeException("打卡日期错误");
        }

        LocalDate begin = beginDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        LocalDate end = clockDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        return Math.abs((int) (end.toEpochDay() - begin.toEpochDay()));
    }

    /**
     * 共几天
     */
    public static Integer getTotalDays(Date beginDate, Date endDate) {

        if (Objects.isNull(beginDate)) {
            throw new RuntimeException("开课日期错误");
        }

        if (Objects.isNull(endDate)) {
            throw new RuntimeException("结束日期错误");
        }

        if (beginDate.after(endDate)) {
            throw new RuntimeException("开课日期不能大于结束日期");
        }

        LocalDate begin = beginDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        LocalDate end = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        return (int) (end.toEpochDay() - begin.toEpochDay()) + 1;
    }
}
