package cn.yoofans.knowledge.center.api.remoteservice.comment;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.comment.CommentRecordDto;
import cn.yoofans.knowledge.center.api.param.comment.CommentRecordParam;

/**
 * Created by zhangshun on 2018/5/25,14:18:49.
 */
@AdvancedFeignClient
public interface RemoteCommentRecordService {

    /**
     * 观点点赞
     *
     * @param param
     * @return
     */
    boolean praise(CommentRecordParam param);

    /**
     * 获取我已点赞的观点
     *
     * @param userId
     * @return
     */
    List<Long> findCommentByUserId(Long userId);

    /**
     * 根据用户和观点查询
     *
     * @param userId
     * @param commentId
     * @return
     */
    CommentRecordDto getByUserComment(Long userId, Long commentId);

}
