package cn.yoofans.knowledge.center.api.remoteservice.comment;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.comment.CommentDto;
import cn.yoofans.knowledge.center.api.param.comment.CommentTopSearchParam;

/**
 * Created by zhangshun on 2018/5/24,13:37:09.
 */
@AdvancedFeignClient
public interface RemoteCommentTopService {

    /**
     * 分页查询个数
     *
     * @param param
     * @return
     */
    Long countByPage(CommentTopSearchParam param);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<CommentDto> findByPage(CommentTopSearchParam param);

    boolean deleteByUserRead(Long userId, Long readId);

    /**
     * 删除置顶评论缓存
     */
    @Deprecated
    void removeCacheCommentTop();
}
