package cn.yoofans.knowledge.center.api.remoteservice.read;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.read.ReadBookCourseTmplDto;

/**
 * Created by zhangshun on 2018/6/27,13:50:05.
 */
@AdvancedFeignClient
public interface RemoteReadBookCourseTmplService {

    /**
     * 插入
     *
     * @param readBookCourseTmplDto
     */
    boolean insert(ReadBookCourseTmplDto readBookCourseTmplDto);

    /**
     * 按照Id更新
     *
     * @param readBookCourseTmplDto
     */
    boolean updateById(ReadBookCourseTmplDto readBookCourseTmplDto);

    /**
     * 按照书籍id查询
     *
     * @param id
     * @return
     */
    ReadBookCourseTmplDto getById(Long id);

    /**
     * 按照期数id查询
     *
     * @param readId
     * @param bookCourseId
     * @return
     */
    List<ReadBookCourseTmplDto> findByReadCourse(Long readId, Long bookCourseId);

    ReadBookCourseTmplDto getByReadCourse(Long readId, Long bookCourseId);

}
