package cn.yoofans.knowledge.center.api.dto.page;

import java.io.Serializable;
import java.util.List;

/**
 * 产品详情页dto
 * @author zhanghuifeng
 * @date 2018/7/5下午2:21
 */
public class ItemDetailPageDto implements Serializable {

    private static final long serialVersionUID = -2107553991639711480L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 产品ID
     */
    private Long itemId;

    /**
     * 产品类型 @see ItemTypeEnum
     */
    private Integer itemType;

    /**
     * 详情名称
     */
    private String detailName;

    /**
     * 详情内容
     */
    private String content;

    /**
     * 是否默认，1：是，2：否
     * @see cn.yoofans.knowledge.center.api.enums.page.DetailPageIsDefaultEnum
     */
    private Integer isDefault;

    /**
     * 详情页与计划关联集合
     */
    private List<DetailPageItemRelationDto> relationList;

    public List<DetailPageItemRelationDto> getRelationList() {
        return relationList;
    }

    public void setRelationList(List<DetailPageItemRelationDto> relationList) {
        this.relationList = relationList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Integer getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }
}
