package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.account.CapitalAccountDetailDTO;
import cn.yoofans.knowledge.center.api.param.BasePageReqParam;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * 资金账户流水远程调用service
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteCapitalAccountDetailService {
    /**
     * 新增数据
     *
     * @param detailDTO 账户流水详情
     * @return CapitalAccountDetailDTO
     */
    Boolean create(CapitalAccountDetailDTO detailDTO) throws BizException;

    /**
     * 删除数据
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 修改数据
     *
     * @param updateDTO
     * @return
     */
    Boolean update(CapitalAccountDetailDTO updateDTO) throws BizException;

    /**
     * 依据consumerId查询数据
     *
     * @param consumerId
     * @return
     */
    List<CapitalAccountDetailDTO> findByConsumerId(Long consumerId);

    /**
     * 依据Id查询数据
     *
     * @param id
     * @return
     */
    CapitalAccountDetailDTO findById(Long id);

    /**
     * 依据consumerId和业务类型查询数据
     *
     * @param consumerId
     * @param bussinessTypes
     * @return
     */
    List<CapitalAccountDetailDTO> findByConsumerIdAndBusinessType(Long consumerId, List<Integer> bussinessTypes) throws BizException;

    /**
     * 依据consumerId和操作类型查询数据
     *
     * @param consumerId
     * @param operateType
     * @return
     */
    List<CapitalAccountDetailDTO> findByConsumerIdAndOperateType(Long consumerId, Integer operateType) throws BizException;

    /**
     * 依据consumerId和业务类型分页查询数据
     *
     * @param consumerId
     * @param bussinessTypes
     * @param
     * @return
     * @throws BizException
     */
    PageImpl<CapitalAccountDetailDTO> findWaterflowByConsumerIdAndBusinessType(Long consumerId, List<Integer> bussinessTypes, BasePageReqParam pageReqParam) throws BizException;

}
