package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.redpoint.UserRedPointShowStatusDto;

import java.util.List;

/**
 * 用户红点service
 * @author zhanghuifeng
 * @date 2018/5/10下午5:06
 */
@AdvancedFeignClient
public interface RemoteUserRedPointService {


    /**
     * 更新红点状态
     * @param consumerId    用户ID
     * @param functionsType 功能  @see RedPointFunctionsTypeEnum
     * @param showStatus    展示状态 @see UserRedPointShowStatus
     * @return boolen
     */
    Boolean updateShowStatus(Long consumerId, Integer functionsType, Integer showStatus);

    /**
     * 根据用户ID和功能列表获取小红点展示状态
     * @param consumerId 用户ID
     * @param list 功能列表
     * @return 结果
     */
    List<UserRedPointShowStatusDto> findShowStatusList(Long consumerId, List<Integer> list);
}
