package cn.yoofans.knowledge.center.api.remoteservice.read;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.data.domain.PageImpl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.read.ReadSimpleDTO;
import cn.yoofans.knowledge.center.api.dto.read.UserNewestReadDTO;
import cn.yoofans.knowledge.center.api.dto.read.UserReadCourseDTO;
import cn.yoofans.knowledge.center.api.dto.read.UserReadDto;
import cn.yoofans.knowledge.center.api.dto.read.UserReadStateDetailDTO;
import cn.yoofans.knowledge.center.api.dto.read.UserReadTeacherDto;
import cn.yoofans.knowledge.center.api.param.read.RemoteReadPastParam;

/**
 * Created by zhangshun on 2018/5/23,10:45:42.
 */
@AdvancedFeignClient
public interface RemoteUserReadService {

    /**
     * 更新用户读书信息
     *
     * @param userReadDto
     * @return
     */
    boolean updateById(UserReadDto userReadDto);

    /**
     * 获取用户读书开课日期
     *
     * @param userId
     * @return
     */
    Date getBeginDate(Long userId);

    /**
     * 获取用户阅读
     *
     * @param orderId 订单ID
     * @return
     */
    UserReadDto getReadByOrderId(String orderId);

    /**
     * 获取用户阅读
     *
     * @param userId 用户ID
     * @return
     */
    UserReadTeacherDto getReadByUserId(Long userId);

    /**
     * 获取用户阅读
     *
     * @param userId 用户ID
     * @param readId 阅读ID
     * @return
     */
    UserReadDto getReadByUserAndRead(Long userId, Long readId);

    /**
     * 获取用户阅读状态
     *
     * @param userId    用户ID
     * @param clockDate 操作日志
     * @return
     */
    UserReadStateDetailDTO getReadStateDetail(Long userId, Date clockDate);

    /**
     * 获取今日课程
     *
     * @param userId    用户ID
     * @param clockDate 操作时间
     * @return
     */
    UserReadCourseDTO getUserReadCourse(Long userId, Date clockDate);

    /**
     * 更新海报URL
     *
     * @param userId
     * @return
     */
    boolean updateDiplomaImgUrl(Long userId, Long readId, String imgUrl);

    /**
     * 查询用户已购
     *
     * @param readId
     * @return
     */
    List<UserReadDto> getByRead(Long readId);

    /**
     * 往期阅读
     *
     * @param remoteReadPastParams
     * @return
     */
    PageImpl<ReadSimpleDTO> findByPage(RemoteReadPastParam remoteReadPastParams);

    /**
     * 查询我的已购阅读的结束时间
     *
     * @param userId
     * @return
     */
    Map<String, String> getExpDateByUserId(Long userId);

    /**
     * 获取最大过期日期的已购阅读
     *
     * @param userId
     * @return
     */
    UserReadDto getNewestByUserId(Long userId);

    /**
     * 获取用户最新的阅读信息
     *
     * @param userId
     * @return
     */
    UserNewestReadDTO getUserNewestReadInfo(Long userId);

}
