package cn.yoofans.knowledge.center.api.enums;

/**
 * Created by sunyan on 2018/4/13.
 */
public enum ItemTypeEnum {
    COURSE(1, "单课"),

    COLUMN(2, "专栏"),

    READ(4, "阅读");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    ItemTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的商品类型
     *
     * @param code
     * @return
     */
    public static ItemTypeEnum getByCode(Integer code) {
        for (ItemTypeEnum status : ItemTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
