package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.coupon.CouponTemplateDto;
import cn.yoofans.knowledge.center.api.dto.coupon.CouponTemplatePageDto;
import cn.yoofans.knowledge.center.api.dto.coupon.CouponTemplateSimpleDto;
import cn.yoofans.knowledge.center.api.param.coupon.CouponTemplateParams;
import cn.yoofans.knowledge.center.api.param.coupon.CouponTemplateQryParams;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * 优惠券母版接口
 * @author zhanghuifeng
 * @date 2018/4/23下午2:58
 */
@AdvancedFeignClient
public interface RemoteCouponTemplateService {

    /**
     * 分页查询优惠券母版信息
     * @param qryParam 查询条件
     * @return 分页结果
     */
    PageImpl<CouponTemplatePageDto> findPage(CouponTemplateQryParams qryParam);

    /**
     * 删除母版信息
     * @param couponTemplateId 母版ID
     * @return 结果
     */
    Boolean deleteTemplate(String couponTemplateId);

    /**
     * 更新优惠券母版状态
     * @param couponTemplateId     母版ID
     * @param toStatus 母版状态
     * @return 结果
     */
    Boolean updateStatus(String couponTemplateId, Integer toStatus);

    /**
     * 保存优惠券母版
     * @param param 母版信息
     * @return 结果
     */
    Boolean save(CouponTemplateParams param);

    /**
     * 根据优惠券母版主键ID查询优惠券母版信息
     * @param couponTemplateId 优惠券母版ID
     * @return 母版信息
     */
    CouponTemplateDto findByCouponTemplateId(String couponTemplateId);

    /**
     * 获取优惠券母版简单信息列表
     * @return 集合
     */
    List<CouponTemplateSimpleDto> findSimpleInfoList();
}
