package cn.yoofans.knowledge.center.api.remoteservice.billboard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.billboard.DistributeBillBoardDTO;
import cn.yoofans.knowledge.center.api.param.billboard.BillBoardPageParam;
import org.springframework.data.domain.PageImpl;

import java.time.LocalDate;
import java.util.List;

/**
 * 排行榜remote接口
 */
@AdvancedFeignClient
public interface RemoteDistributeBillBoardService {

    /**
     * 删除排行榜
     * @param id
     * @return
     */
    Boolean deleteByPrimaryKey(Long id);

    /**
     * 插入
     * @param dto
     * @return
     */
    Long save(DistributeBillBoardDTO dto);

    /**
     * 通过id查询
     * @param id
     * @return
     */
    DistributeBillBoardDTO selectByPrimaryKey(Long id);

    /**
     * 分分页查询
     * @param pageParam
     * @return
     */
    PageImpl<DistributeBillBoardDTO> findPageList(BillBoardPageParam pageParam);

    /**
     * 通过id批量查询
     */
    List<DistributeBillBoardDTO> selectByIds(List<Long> ids);

    /**
     * 获取满足当前时间的排行榜
     * @param date 时间
     * @return
     */
    DistributeBillBoardDTO findByDate(LocalDate date);

}