package cn.yoofans.knowledge.center.api.dto.refund;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import lombok.Data;

import java.util.Date;

@Data
public class AfterSalesDTO extends BaseDTO {

    /**
     * 订单编号
     */
    private String orderId;

    /**
     * 商品ID
     */
    private Long itemId;

    /**
     * 商品类型：1=单课，2=专栏，3=vip商品，4=阅读
     */
    private Integer itemType;

    /**
     * 阅读期数ID
     */
    private Long readStageId;

    /**
     * 分销金额（分）
     */
    private Integer distributeAmount;

    /**
     * 订单状态，TO_PAY-待付款/SUCCESS-订单成功/FAILED-订单失败/REFUNDING-退款中/REFUNDED-退款成功/REFUND_FAIL-退款失败
     */
    private String orderStatus;

    /**
     * 过期时间
     */
    private Date overdueTime;

}