package cn.yoofans.knowledge.center.api.dto.refund;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import lombok.Data;

@Data
public class RefundRecordDTO extends BaseDTO {

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 退款金额 单位(分)
     */
    private Integer refundAmount;

    /**
     * 平台补贴金额 单位分
     */
    private Integer platformSubsidy;

    /**
     * 退款状态  REFUNDING 退款中 REFUNDED 退款成功 REFUND_FAIL 退款失败
     */
    private String refundStatus;

    /**
     * 操作人员类型 1用户 2管理员
     */
    private Integer operatorType;

    /**
     * 操作人员姓名
     */
    private String operatorName;

    /**
     * 操作状态 WAIT_PROCESS 待处理  PROCESSING 处理中 PROCESS_SUCCESS 处理成功
     */
    private String operationStatus;

    /**
     * 备注
     */
    private String remark;


}