package cn.yoofans.knowledge.center.api.enums;

/**
 * 课程类型枚举类
 */
public enum CourseCategoryEnum {
    OTHER(0, "其他"),

    AUDIO(1, "音频");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CourseCategoryEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的课程类型
     *
     * @param code
     * @return
     */
    public static CourseCategoryEnum getByCode(Integer code) {
        for (CourseCategoryEnum status : CourseCategoryEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
