package cn.yoofans.knowledge.center.api.enums.coupon;

/**
 * 优惠券母版状态枚举
 * @author zhanghuifeng
 * @date 2018/4/24上午10:19
 */
public enum CouponTemplateStatusEnum {
    OFF_LINE(-1, "已下线"),
    READY_LINE(0, "待上线"),
    ON_LINE(1, "已上线");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CouponTemplateStatusEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static CouponTemplateStatusEnum getByCode(Integer code) {
        for (CouponTemplateStatusEnum enumVal : CouponTemplateStatusEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }
}
