/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteReadStageService
 * Author:   amu
 * Date:     2018/5/22 下午9:00
 * Description: 一修读书阅读计划期数
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice.refund;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.read.ReadStageDTO;
import cn.yoofans.knowledge.center.api.dto.refund.AfterSalesDTO;
import cn.yoofans.knowledge.center.api.param.read.ReadStageParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 售后远程调用接口
 */
@AdvancedFeignClient
public interface RemoteAfterSalesService {

    /**
     * 新增数据
     *
     * @param dto
     * @return
     */
    Long insert(AfterSalesDTO dto);

    /**
     * 依据主键删除数据
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 依据主键集合删除数据
     *
     * @param ids
     * @return
     */
    Boolean deleteByIds(List<Long> ids);

    /**
     * 修改数据
     *
     * @param dto
     * @return
     */
    Boolean update(AfterSalesDTO dto);

    /**
     * 依据阅读计划id和期数id修改过期时间
     *
     * @param readId
     * @param stageId
     * @param overduerTime
     * @return
     */
    Boolean updateOverdueTimeByReadIdAndStageId(Long readId, Long stageId, Date overduerTime);

    /**
     * 依据orderId查询数据
     *
     * @param orderId
     * @return
     */
    AfterSalesDTO selectOneByOrderId(String orderId);


    /**
     * 依据主键查询数据
     *
     * @param id
     * @return
     */
    AfterSalesDTO selectOneByPrimaryKey(Long id);

    /**
     * 依据订单状态和过期时间查询数据
     *
     * @param orderStatus
     * @param overdueTime
     * @return
     */
    List<AfterSalesDTO> selectOverdueListByOrderStatus(String orderStatus, Date overdueTime);

}
