package cn.yoofans.knowledge.center.api.remoteservice.refund;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.refund.OrderRefundErrorDTO;

/**
 * 异常退款订单远程调用接口
 */
@AdvancedFeignClient
public interface RemoteOrderRefundErrorService {

    /**
     * 新增数据
     *
     * @param dto
     * @return
     */
    OrderRefundErrorDTO insert(OrderRefundErrorDTO dto);

    /**
     * 依据id删除数据
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 修改数据
     *
     * @param dto
     * @return
     */
    Boolean update(OrderRefundErrorDTO dto);

    /**
     * 修改id修改操作状态
     *
     * @param id
     * @param operateStatus
     * @return
     */
    Boolean updateOperateStatusById(Long id, Integer operateStatus);

    /**
     * 依据主键Id查询数据
     *
     * @param id
     * @return
     */
    OrderRefundErrorDTO selectOneById(Long id);

    /**
     * 依据订单Id查询数据
     *
     * @param orderId
     * @return
     */
    OrderRefundErrorDTO selectOneByOrderId(String orderId);


}