package cn.yoofans.knowledge.center.api.enums.account;

/**
 * 提现结果状态枚举
 * @author zhanghuifeng
 * @date 2018/5/15上午11:34
 */
public enum WithdrawStatusEnum {
    DEALING(-1, "处理中"),

    FAIL(0, "交易失败"),

    SUCCESS(1, "交易成功");


    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    WithdrawStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取
     *
     * @param code
     * @return
     */
    public static WithdrawStatusEnum getByCode(Integer code) {
        for (WithdrawStatusEnum status : WithdrawStatusEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
