package cn.yoofans.knowledge.center.api.enums.refund;

import java.util.Objects;

/**
 * 操作状态枚举
 * Created by qiuyp
 */
public enum OperationStatusEnum {
    WAIT_PROCESS("WAIT_PROCESS", "待处理"),
    PROCESSING("PROCESSING", "处理中"),
    PROCESS_SUCCESS("PROCESS_SUCCESS", "处理成功");

    /**
     * 代码
     */
    private String code;

    /**
     * 描述
     */
    private String desc;

    OperationStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static OperationStatusEnum getByCode(String code) {
        for (OperationStatusEnum value : OperationStatusEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(String code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
