package cn.yoofans.knowledge.center.api.param.refund;

import lombok.Data;

import java.io.Serializable;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import cn.yoofans.knowledge.center.api.param.BasePageReqParam;

@Data
public class RefundParams implements Serializable {

    private static final long serialVersionUID = -3337612229951809802L;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 退款金额 单位(分)
     */
    private Integer refundAmount;

    /**
     * 平台补贴金额 单位分
     */
    private Integer platformSubsidy;

    /**
     * 操作人员类型 1用户 2管理员
     * {@link cn.yoofans.knowledge.center.api.enums.refund.OperatorTypeEnum}
     */
    private Integer operatorType;

    /**
     * 操作人员姓名
     */
    private String operatorName;


    /**
     * 退款类型 1 无理由退款 2 强制退款
     */
    private Integer refundType;

    /**
     * 备注
     */
    private String remark;





}