package cn.yoofans.knowledge.center.api.remoteservice.read;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.read.UserStatDto;

/**
 * Created by zhangshun on 2018/5/23,10:45:42.
 */
@AdvancedFeignClient
public interface RemoteUserStatService {

    /**
     * 根据用户ID更新用户统计信息
     *
     * @param userStatDto
     * @return
     */
    Boolean updateByUser(UserStatDto userStatDto);

    /**
     * 检查用户阅读状态
     *
     * @param userId
     * @return
     */
    Boolean changeReadStatus(Long userId);

    /**
     * 获取用户统计信息
     *
     * @param userId 用户ID
     * @return
     */
    UserStatDto getUserStatByUserId(Long userId);

    /**
     * 处理用户登录天数
     *
     * @param userId
     * @return
     */
    boolean handlerUserLoginDays(Long userId);

    /**
     * 处理用户听书时间
     *
     * @param userId
     * @return
     */
    boolean handlerUserListens(Long userId);
}
