package cn.yoofans.knowledge.center.api.remoteservice.refund;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.refund.RefundRecordDTO;

/**
 * 退款记录远程调用服务
 */
@AdvancedFeignClient
public interface RemoteRefundRecordService {

    /**
     * 新增退款数据
     *
     * @param dto
     * @return
     */
    Long insert(RefundRecordDTO dto);

    /**
     * 依据id删除数据
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 修改数据
     *
     * @param dto
     * @return
     */
    Boolean update(RefundRecordDTO dto);

    /**
     * 依据主键Id 查询数据
     *
     * @param id
     * @return
     */
    RefundRecordDTO selectOneById(Long id);

    /**
     * 依据订单号查询退款数据
     *
     * @param orderId
     * @return
     */
    RefundRecordDTO selectByOrderId(String orderId);
}