/*
 * Decompiled with CFR 0.152.
 */
package cn.yoofans.knowledge.center.api.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class ReadDayUtils {
    public static String diffDate(Date date1) {
        Calendar date = Calendar.getInstance();
        date.setTime(date1);
        date.set(10, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        Calendar today = Calendar.getInstance();
        today.set(10, 23);
        today.set(12, 59);
        today.set(13, 59);
        today.set(14, 999);
        if (today.getTime().before(date.getTime())) {
            return "after";
        }
        today.set(10, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        date.add(5, 1);
        if (today.getTime().after(date.getTime())) {
            return "before";
        }
        return "today";
    }

    public static Integer getReadPastDays(Date beginDate, Date clockDate) {
        if (Objects.isNull(beginDate)) {
            throw new RuntimeException("\u5f00\u8bfe\u65e5\u671f\u9519\u8bef");
        }
        if (Objects.isNull(clockDate)) {
            throw new RuntimeException("\u6253\u5361\u65e5\u671f\u9519\u8bef");
        }
        LocalDate begin = beginDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate end = clockDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return Math.abs((int)(end.toEpochDay() - begin.toEpochDay() + 1L));
    }

    public static Integer getReadAfterDays(Date beginDate, Date clockDate) {
        if (Objects.isNull(beginDate)) {
            throw new RuntimeException("\u5f00\u8bfe\u65e5\u671f\u9519\u8bef");
        }
        if (Objects.isNull(clockDate)) {
            throw new RuntimeException("\u6253\u5361\u65e5\u671f\u9519\u8bef");
        }
        LocalDate begin = beginDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate end = clockDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return Math.abs((int)(end.toEpochDay() - begin.toEpochDay()));
    }

    public static Integer getTotalDays(Date beginDate, Date endDate) {
        if (Objects.isNull(beginDate)) {
            throw new RuntimeException("\u5f00\u8bfe\u65e5\u671f\u9519\u8bef");
        }
        if (Objects.isNull(endDate)) {
            throw new RuntimeException("\u7ed3\u675f\u65e5\u671f\u9519\u8bef");
        }
        if (beginDate.after(endDate)) {
            throw new RuntimeException("\u5f00\u8bfe\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
        }
        LocalDate begin = beginDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate end = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return (int)(end.toEpochDay() - begin.toEpochDay()) + 1;
    }
}

