package cn.yoofans.knowledge.center.api.enums.read;

/**
 * @Author danke
 * @Date :Create in 下午8:26 2018/8/7
 * 阅读计划类型枚举
 */
public enum ReadTypeEnum {

    FORMAL(0, "正式阅读计划"),
    EXPERI(1, "体验阅读计划");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    ReadTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     *
     *
     * @param code
     * @return
     */
    public static ReadTypeEnum getByCode(Integer code) {
        for (ReadTypeEnum status : ReadTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
