package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.distribution.DistributorDTO;
import cn.yoofans.knowledge.center.api.param.DistributorPageReqParams;
import org.springframework.data.domain.PageImpl;

/**
 * 分销员远程调用Service
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteDistributorService {

    /**
     * 新增分销员
     *
     * @param dto
     * @return
     */
    public DistributorDTO add(DistributorDTO dto);

    /**
     * 删除分销员
     *
     * @param id
     * @return
     */
    public Boolean deleteById(Long id);

    /**
     * 修改分销员
     *
     * @param dto
     * @return
     */
    public Boolean update(DistributorDTO dto) throws BizException;

    /**
     * 依据Id查询
     *
     * @param id
     * @return
     */
    public DistributorDTO findById(Long id);

    /**
     * 分页查询
     *
     * @param requestParam
     * @return
     */
    public PageImpl<DistributorDTO> getPageList(DistributorPageReqParams requestParam);


}
