package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.account.UserWithdrawRecordDto;
import cn.yoofans.knowledge.center.api.param.BasePageReqParam;
import org.springframework.data.domain.PageImpl;


/**
 * 用户提现记录service
 * @author zhanghuifeng
 * @date 2018/5/15下午2:19
 */
@AdvancedFeignClient
public interface RemoteUserWithdrawRecordService {

    /**
     * 根据用户ID查询提现记录
     * @param consumerId 用户ID
     * @param pageReqParam
     * @return 记录集合
     */
    PageImpl<UserWithdrawRecordDto> findPage(Long consumerId, BasePageReqParam pageReqParam);
}
