package cn.yoofans.knowledge.center.api.dto.read;

import java.io.Serializable;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * 用户统计信息
 * Created by zhangshun on 2018/5/23,07:52:08.
 */
public class UserStatDto implements Serializable {

    /**
     * y
     */
    private Long id;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户昵称
     */
    private String userNickname;

    /**
     * 用户头像
     */
    private String userHeadImgUrl;

    /**
     * 业务类型:1=阅读
     */
    private Integer statType;

    /**
     * 听书时间：单位：分
     */
    private Integer listens;

    /**
     * 打卡数
     */
    private Integer clocks;

    /**
     * 听书数
     */
    private Integer books;

    /**
     * 登录天数
     */
    private Integer loginDays;

    /**
     * 阅读ID
     */
    private Long readId;

    /**
     * 阅读状态：0=新用户、1=待开课、2=阅读中、3=已读完
     */
    private Integer readState;

    /**
     * 是否关注公众号
     */
    private Boolean followOfficialAccount;

    /**
     * 最后登录时间
     */
    private String lastLoginTime;

    /**
     * 我的老师微信号
     */
    private String teacherWxNumber;

    /**
     * 我的老师微信地址
     */
    private String teacherWxQrcodeUrl;

    private Long lecturerId;

    /**
     * 用户答题累积得分
     */
    private Integer totalScore;

    /**
     * 用户满分次数
     */
    private Integer rightAllCount;

    /**
     * 用户期数id
     */
    private Long readStageId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserNickname() {
        return userNickname;
    }

    public void setUserNickname(String userNickname) {
        this.userNickname = userNickname;
    }

    public String getUserHeadImgUrl() {
        return userHeadImgUrl;
    }

    public void setUserHeadImgUrl(String userHeadImgUrl) {
        this.userHeadImgUrl = userHeadImgUrl;
    }

    public Integer getStatType() {
        return statType;
    }

    public void setStatType(Integer statType) {
        this.statType = statType;
    }

    public Integer getListens() {
        return listens;
    }

    public void setListens(Integer listens) {
        this.listens = listens;
    }

    public Integer getClocks() {
        return clocks;
    }

    public void setClocks(Integer clocks) {
        this.clocks = clocks;
    }

    public Integer getBooks() {
        return books;
    }

    public void setBooks(Integer books) {
        this.books = books;
    }

    public Integer getLoginDays() {
        return loginDays;
    }

    public void setLoginDays(Integer loginDays) {
        this.loginDays = loginDays;
    }

    public Long getReadId() {
        return readId;
    }

    public void setReadId(Long readId) {
        this.readId = readId;
    }

    public Integer getReadState() {
        return readState;
    }

    public void setReadState(Integer readState) {
        this.readState = readState;
    }

    public String getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(String lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getTeacherWxNumber() {
        return teacherWxNumber;
    }

    public void setTeacherWxNumber(String teacherWxNumber) {
        this.teacherWxNumber = teacherWxNumber;
    }

    public String getTeacherWxQrcodeUrl() {
        return teacherWxQrcodeUrl;
    }

    public void setTeacherWxQrcodeUrl(String teacherWxQrcodeUrl) {
        this.teacherWxQrcodeUrl = teacherWxQrcodeUrl;
    }

    public Boolean getFollowOfficialAccount() {
        return followOfficialAccount;
    }

    public void setFollowOfficialAccount(Boolean followOfficialAccount) {
        this.followOfficialAccount = followOfficialAccount;
    }

    public Long getLecturerId() {
        return lecturerId;
    }

    public void setLecturerId(Long lecturerId) {
        this.lecturerId = lecturerId;
    }

    public Integer getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(Integer totalScore) {
        this.totalScore = totalScore;
    }

    public Integer getRightAllCount() {
        return rightAllCount;
    }

    public void setRightAllCount(Integer rightAllCount) {
        this.rightAllCount = rightAllCount;
    }

    public Long getReadStageId() {
        return readStageId;
    }

    public void setReadStageId(Long readStageId) {
        this.readStageId = readStageId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
