package cn.yoofans.knowledge.center.api.dto.sns;

import cn.yoofans.knowledge.center.api.dto.BaseDTO;
import lombok.Data;

import java.util.Date;

/**
 * 朋友圈信息实体
 */
@Data
public class SnsInfoDTO extends BaseDTO {

    /**
     * 判断9月3号以后感想海报和打卡海报区分标识
     * 1=9月3日后的感想海报页
     * 2=9月3日后的新打卡海报页
     */
    public static final Integer THOUGHTS = 1;
    public static final Integer CLOCK = 2;

    /**
     * 文件上传id
     */
    private Long recordId;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 阅读计划Id
     */
    private Long readId;


    /**
     * 期数id
     */
    private Long readStageId;

    /**
     * 讲师id
     */
    private Long lecturerId;

    /**
     * 打卡时间
     */
    private Date clockTime;

    /**
     * 类型
     * 1=感想海报页
     * 2=打卡海报页
     */
    private Integer type;

    /**
     * 数据有效标志，true处理,false过滤
     */
    private Boolean effectiveSign = false;

}