package cn.yoofans.knowledge.center.api.dto.stat;

import cn.yoofans.knowledge.center.api.enums.stat.UserClockTypeEnum;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * Created by zhangshun on 2018/7/18,11:29:28.
 */
public class UserStatDetailDto implements Serializable {

    private static final long serialVersionUID = -1837245500761437458L;

    private Long id;

    private Long userId;

    private Long bizId;

    private Integer bizType;

    private Date bizTime;

    private Integer bizState;

    private String statName;

    private String statValue;

    private Date gmtCreate;

    private Date gmtModified;

    private Long stageId;

    private Long courseId;

    private String evidence;

    private String remark;

    private Integer snsProcessSign;

    private Long clockProcessId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getBizId() {
        return bizId;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public Date getBizTime() {
        return bizTime;
    }

    public void setBizTime(Date bizTime) {
        this.bizTime = bizTime;
    }

    public Integer getBizState() {
        return bizState;
    }

    public void setBizState(Integer bizState) {
        this.bizState = bizState;
    }

    public String getStatName() {
        return statName;
    }

    public void setStatName(String statName) {
        this.statName = statName;
    }

    public String getStatValue() {
        return statValue;
    }

    public void setStatValue(String statValue) {
        this.statValue = statValue;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public String getGroupKey() {
        if (null == gmtCreate || null == bizTime) {
            return null;
        }

        if (Objects.equals(UserClockTypeEnum.CLOCK.getCode(), getBizState())) {
            return DateFormatUtils.format(gmtCreate, "yyyy-MM-dd");
        } else {
            return DateFormatUtils.format(bizTime, "yyyy-MM-dd");
        }
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getStageId() {
        return stageId;
    }

    public void setStageId(Long stageId) {
        this.stageId = stageId;
    }

    public Long getCourseId() {
        return courseId;
    }

    public void setCourseId(Long courseId) {
        this.courseId = courseId;
    }

    public String getEvidence() {
        return evidence;
    }

    public void setEvidence(String evidence) {
        this.evidence = evidence;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getSnsProcessSign() {
        return snsProcessSign;
    }

    public void setSnsProcessSign(Integer snsProcessSign) {
        this.snsProcessSign = snsProcessSign;
    }

    public Long getClockProcessId() {
        return clockProcessId;
    }

    public void setClockProcessId(Long clockProcessId) {
        this.clockProcessId = clockProcessId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
