package cn.yoofans.knowledge.center.api.enums.jdgiftbook;

import java.io.Serializable;

/**
 * 专栏枚举类
 */
public enum ReceivedGiftBookStatusEnum implements Serializable {

    WAIT_DRAW(1, "待领取"),

    ALREADY_DRAW(2, "已领取"),

    ALREADY_CANCLE(3, "已取消");
    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    ReceivedGiftBookStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的专栏状态
     *
     * @param code
     * @return
     */
    public static ReceivedGiftBookStatusEnum getByCode(Integer code) {
        for (ReceivedGiftBookStatusEnum status : ReceivedGiftBookStatusEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
