package cn.yoofans.knowledge.center.api.enums.market;

import java.util.Objects;

/**
 * 展示用户类型枚举
 * Created by qiuyp
 */
public enum MarketUserTypeEnum {
    NOT_REBUY_USERS(1, "未复购用户"),
    ALL_USERS(2, "全部用户");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    MarketUserTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static MarketUserTypeEnum getByCode(Integer code) {
        for (MarketUserTypeEnum value : MarketUserTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
