package cn.yoofans.knowledge.center.api.param.coupon;

import cn.yoofans.knowledge.center.api.param.BasePageReqParam;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

/**
 * 优惠券分页查询条件
 *
 * @author zhanghuifeng
 * @date 2018/4/25下午4:42
 */
public class CouponInfoPageQryParams extends BasePageReqParam {

    private static final long serialVersionUID = -3149822902870431027L;

    /**
     * 优惠券母版标题
     */
    private String couponTemplateTitle;

    /**
     * 优惠券母版ID
     */
    private String couponTemplateId;

    private Long templateId;

    /**
     * 优惠券领取开始日期
     */
    private Date createStartTime;

    /**
     * 优惠券领取结束日期
     */
    private Date createEndTime;

    /**
     * 优惠券使用开始日期
     */
    private Date usedStartTime;

    /**
     * 优惠券使用结束日期
     */
    private Date usedEndTime;

    /**
     * 优惠券状态,-1:已过期；0:待使用；1:已使用
     */
    private Integer couponStatus;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 来源类型
     */
    private Integer sourceType;

    /**
     * 来源id
     */
    private String sourceId;

    public String getCouponTemplateTitle() {
        return couponTemplateTitle;
    }

    public void setCouponTemplateTitle(String couponTemplateTitle) {
        this.couponTemplateTitle = couponTemplateTitle;
    }

    public String getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(String couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public Date getCreateStartTime() {
        return createStartTime;
    }

    public void setCreateStartTime(Date createStartTime) {
        this.createStartTime = createStartTime;
    }

    public Date getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(Date createEndTime) {
        this.createEndTime = createEndTime;
    }

    public Date getUsedStartTime() {
        return usedStartTime;
    }

    public void setUsedStartTime(Date usedStartTime) {
        this.usedStartTime = usedStartTime;
    }

    public Date getUsedEndTime() {
        return usedEndTime;
    }

    public void setUsedEndTime(Date usedEndTime) {
        this.usedEndTime = usedEndTime;
    }

    public Integer getCouponStatus() {
        return couponStatus;
    }

    public void setCouponStatus(Integer couponStatus) {
        this.couponStatus = couponStatus;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
