package cn.yoofans.knowledge.center.api.remoteservice.question;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.question.BookCourseQuestionDTO;
import cn.yoofans.knowledge.center.api.dto.question.QuestionDTO;

import java.util.List;

/**
 * @author zhangmm
 * @Description: 图书问题管理rpc
 * @date 2018/9/10 0010 17:22 
*/
@AdvancedFeignClient
public interface RemoteBookCourseService {
    /**
     * 删除问题
     */
    Boolean removeQuestion(Long courseId,Long readId);

    /**
     * 新增问题关联
     * @return boolean
     */
    Boolean addQuestion(BookCourseQuestionDTO dto);

    /**
     * 查询课程关联问题列表
     * @return boolean
     */
    List<QuestionDTO> getQuestionList(BookCourseQuestionDTO dto);

    /**
     * @author zhangmm
     * @Description: 查询该问题是否和课程关联
     * @date 2018/9/11 0011 16:58
     */
    public int selectByQuestionId(Long questionId);

    /**
     * @author zhangmm
     * @Description: 课程下面关联的问题总数
     * @date 2018/9/26 0026 11:31
    */
    public int selectByCourseId(Long courseId,Long readId);

    }
