package cn.yoofans.knowledge.center.api.remoteservice.sns;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.sns.SnsReviewDTO;
import cn.yoofans.knowledge.center.api.dto.sns.UserClockInfoDTO;
import cn.yoofans.knowledge.center.api.param.sns.BatchOperateParams;
import cn.yoofans.knowledge.center.api.param.sns.SnsReviewPageQryParams;
import cn.yoofans.knowledge.center.api.param.sns.SnsReviewParams;
import cn.yoofans.knowledge.center.api.param.sns.SnsStatisticsDetailPageQryParams;
import org.springframework.data.domain.PageImpl;

@AdvancedFeignClient
public interface RemoteSnsReviewService {

    /**
     * 保存数据
     *
     * @param snsReview
     * @return
     */
    Boolean insert(SnsReviewDTO snsReview);

    /**
     * 依据Id删除数据
     *
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 修改
     *
     * @param snsReview
     * @return
     */
    Boolean update(SnsReviewDTO snsReview);

    /**
     * 依据主键id查询数据
     *
     * @param id
     * @return
     */
    SnsReviewDTO findOneById(Long id);

    /**
     * 执行朋友圈数据审核
     *
     * @param param
     * @return
     */
    Boolean doSnsReview(SnsReviewParams param) throws BizException;

    /**
     * 分页查询数据
     *
     * @param queryParams
     * @return
     */
    PageImpl<SnsReviewDTO> findPageList(SnsReviewPageQryParams queryParams);

    /**
     * 统计详情分页查询
     *
     * @param queryParam
     * @return
     */
    PageImpl<UserClockInfoDTO> findStatisticsDetailPageList(SnsStatisticsDetailPageQryParams queryParam);

    /**
     * 批量打卡
     *
     * @param params
     * @return
     */
    Boolean batchClock(BatchOperateParams params) throws BizException;

    /**
     * 批量撤销打卡
     *
     * @param params
     * @return
     */
    Boolean batchRevokeClock(BatchOperateParams params) throws BizException;

}
