package cn.yoofans.knowledge.center.api.dto.order;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

import org.apache.commons.lang3.builder.ToStringBuilder;

public class OrderItemDto implements Serializable {

    private static final long serialVersionUID = 820560337034125643L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 买家ID
     */
    private Long consumerId;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 商品ID
     */
    private Long itemId;

    /**
     * 商品名称
     */
    private String itemName;

    /**
     * 商品图片
     */
    private String itemImage;

    /**
     * 商品价格（单位：分）
     */
    private Integer itemPrice;

    /**
     * 商品类型（单节，专栏）
     */
    private Integer itemType;

    /**
     * 商品种类（音频，视频）
     */
    private Integer itemCategory;

    /**
     * 商品数量
     */
    private Integer itemNum;

    /**
     * 讲师ID
     */
    private Long lecturerId;

    /**
     * 讲师名称
     */
    private String lecturerName;

    /**
     * 讲师分成比例（100=%1）
     */
    private Integer lecturerRate;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 分销比例
     */
    private Integer distributeRate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId == null ? null : orderId.trim();
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName == null ? null : itemName.trim();
    }

    public String getItemImage() {
        return itemImage;
    }

    public void setItemImage(String itemImage) {
        this.itemImage = itemImage == null ? null : itemImage.trim();
    }

    public Integer getItemPrice() {
        return itemPrice;
    }

    public void setItemPrice(Integer itemPrice) {
        this.itemPrice = itemPrice;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Long getLecturerId() {
        return lecturerId;
    }

    public void setLecturerId(Long lecturerId) {
        this.lecturerId = lecturerId;
    }

    public Integer getLecturerRate() {
        return lecturerRate;
    }

    public void setLecturerRate(Integer lecturerRate) {
        this.lecturerRate = lecturerRate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getItemNum() {
        return itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }

    public String getLecturerName() {
        return lecturerName;
    }

    public void setLecturerName(String lecturerName) {
        this.lecturerName = lecturerName;
    }

    public Integer getItemCategory() {
        return itemCategory;
    }

    public void setItemCategory(Integer itemCategory) {
        this.itemCategory = itemCategory;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Integer getDistributeRate() {
        return distributeRate;
    }

    public void setDistributeRate(Integer distributeRate) {
        this.distributeRate = distributeRate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        OrderItemDto that = (OrderItemDto) o;
        return Objects.equals(id, that.id) && Objects.equals(consumerId, that.consumerId) && Objects
            .equals(orderId, that.orderId) && Objects.equals(itemId, that.itemId) && Objects
            .equals(itemName, that.itemName) && Objects.equals(itemImage, that.itemImage) && Objects
            .equals(itemPrice, that.itemPrice) && Objects.equals(itemType, that.itemType) && Objects
            .equals(itemCategory, that.itemCategory) && Objects.equals(itemNum, that.itemNum) && Objects
            .equals(lecturerId, that.lecturerId) && Objects.equals(lecturerName, that.lecturerName) && Objects
            .equals(lecturerRate, that.lecturerRate) && Objects.equals(gmtCreate, that.gmtCreate) && Objects
            .equals(gmtModified, that.gmtModified);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(id, consumerId, orderId, itemId, itemName, itemImage, itemPrice, itemType, itemCategory, itemNum,
                lecturerId, lecturerName, lecturerRate, gmtCreate, gmtModified);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}