package cn.yoofans.knowledge.center.api.dto.read;

import cn.yoofans.knowledge.center.api.enums.read.UserReadBuyStateEnum;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zhangshun on 2018/5/23,11:02:02.
 */
public class UserReadDto implements Serializable {

    private Long id;

    private String orderId;

    private Long consumerId;

    private Long readId;

    private String readTitle;

    private String briefer;

    private Integer orderCount;

    private String bgImgUrl;

    private Long readStageId;

    private Integer readStageSerial;

    private Date beginDate;

    private Date expDate;

    private Integer orderSerial;

    private String diplomaImgUrl;

    private Long authorizerId;

    private Long lecturerId;

    private UserReadStateDetailDTO userReadState;

    private Integer readState;

    private Integer readType;

    /**
     * 购买状态：1=首购、2=复购，体验营没有状态
     * @see UserReadBuyStateEnum
     */
    private Integer buyState;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getReadId() {
        return readId;
    }

    public void setReadId(Long readId) {
        this.readId = readId;
    }

    public String getReadTitle() {
        return readTitle;
    }

    public void setReadTitle(String readTitle) {
        this.readTitle = readTitle;
    }

    public String getBriefer() {
        return briefer;
    }

    public void setBriefer(String briefer) {
        this.briefer = briefer;
    }

    public Integer getOrderCount() {
        return orderCount;
    }

    public void setOrderCount(Integer orderCount) {
        this.orderCount = orderCount;
    }

    public String getBgImgUrl() {
        return bgImgUrl;
    }

    public void setBgImgUrl(String bgImgUrl) {
        this.bgImgUrl = bgImgUrl;
    }

    public Long getReadStageId() {
        return readStageId;
    }

    public void setReadStageId(Long readStageId) {
        this.readStageId = readStageId;
    }

    public Integer getReadStageSerial() {
        return readStageSerial;
    }

    public void setReadStageSerial(Integer readStageSerial) {
        this.readStageSerial = readStageSerial;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getExpDate() {
        return expDate;
    }

    public void setExpDate(Date expDate) {
        this.expDate = expDate;
    }

    public Integer getOrderSerial() {
        return orderSerial;
    }

    public void setOrderSerial(Integer orderSerial) {
        this.orderSerial = orderSerial;
    }

    public String getDiplomaImgUrl() {
        return diplomaImgUrl;
    }

    public void setDiplomaImgUrl(String diplomaImgUrl) {
        this.diplomaImgUrl = diplomaImgUrl;
    }

    public UserReadStateDetailDTO getUserReadState() {
        return userReadState;
    }

    public void setUserReadState(UserReadStateDetailDTO userReadState) {
        this.userReadState = userReadState;
    }

    public Long getAuthorizerId() {
        return authorizerId;
    }

    public void setAuthorizerId(Long authorizerId) {
        this.authorizerId = authorizerId;
    }

    public Long getLecturerId() {
        return lecturerId;
    }

    public void setLecturerId(Long lecturerId) {
        this.lecturerId = lecturerId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getKeyOfUserIdAndReadId() {
        return this.consumerId + "-" + this.readId;
    }

    public Integer getReadState() {
        return readState;
    }

    public void setReadState(Integer readState) {
        this.readState = readState;
    }

    public Integer getReadType() {
        return readType;
    }

    public void setReadType(Integer readType) {
        this.readType = readType;
    }

    public Integer getBuyState() {
        return buyState;
    }

    public void setBuyState(Integer buyState) {
        this.buyState = buyState;
    }
}
