package cn.yoofans.knowledge.center.api.enums.coupon;

import java.util.Objects;

/**
 * 活动状态
 * Created by qiuyp
 */
public enum ActivityStatusEnum {

    OFF_LINE(-1, "已下线"),
    READY_LINE(0, "待上线"),
    ON_LINE(1, "已上线");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    ActivityStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static ActivityStatusEnum getByCode(Integer code) {
        for (ActivityStatusEnum value : ActivityStatusEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
