package cn.yoofans.knowledge.center.api.enums.distribution;

/**
 * 分销抽成类型枚举
 * @author zhanghuifeng
 * @date 2018/7/31下午5:31
 */
public enum DistributionCommissionTypeEnum {

    RATE(1, "百分比"),
    RMB(2, "人民币");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    DistributionCommissionTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     *
     *
     * @param code
     * @return
     */
    public static DistributionCommissionTypeEnum getByCode(Integer code) {
        for (DistributionCommissionTypeEnum status : DistributionCommissionTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
