package cn.yoofans.knowledge.center.api.remoteservice.jdgift;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.jdgiftbook.*;
import cn.yoofans.knowledge.center.api.param.jdgiftbook.GiftBookParams;
import cn.yoofans.knowledge.center.api.param.jdgiftbook.GiftOrderParams;
import cn.yoofans.knowledge.center.api.param.jdgiftbook.PaperBookParams;
import cn.yoofans.knowledge.center.api.param.jdgiftbook.ReceivedGiftParams;

import java.util.List;

/**
 * @author zhangmm
 * @Description: 赠书rpc接口
 * @date 2018/9/14 0014 19:04
 */
@AdvancedFeignClient
public interface RemoteJDGiftBookService {

    public List<PaperBookDTO> getPaperBookList(PaperBookParams paperBookParams);

    public Boolean save(PaperBookParams params);

    public Boolean delete(Long id);

    public List<GiftBookDTO> getGiftBookList(GiftBookParams params);

    public Boolean saveGiftBook(GiftBookParams params);

    public Boolean deleteGiftBook(Long id);

    public GiftBookDTO selectByPrimaryKey(Long id);

    public List<PaperBookDTO> findUserListByIds(List<Long> ids);

    public List<GiftOrderDTO> getGiftOrderInfo(Long userId);

    public List<GiftOrderDTO> getGiftOrderList(GiftOrderParams giftOrderParams);

    public GiftOrderDTO getGiftOrderDetail(Long id);

    public List<ReceivedGiftDTO> getReceivedGiftList(ReceivedGiftParams receivedGiftDTOS);

    public Boolean updateGiftOrder(GiftOrderParams params);

    public List<ReceivedGiftDTO> findUserAlredayDraw(Long userId, Long readStageId);

    public Long paperBookCount(PaperBookParams params);

    public Long giftOrderCount(GiftOrderParams giftOrderParams);

    public Long giftBookCount(GiftBookParams params);

    public Long receivedGiftCount(ReceivedGiftParams params);

    public List<PaperBookDTO> taskCenterList();

    List<GiftOrderDTO> getGiftOrderByGiftOrderIds(List<String> orderIds);

    public List<GiftBookRelatedBookDTO> selectByid(GiftBookRelatedBookDTO dto);

    public List<GiftBookDTO> giftBookList(List<Long> ids);
}
