/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteReadStageService
 * Author:   amu
 * Date:     2018/5/22 下午9:00
 * Description: 一修读书阅读计划期数
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice.read;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.read.ReadStageTeacherDTO;

/**
 * 〈一句话功能简述〉<br>
 * 〈一修读书阅读计划期数远程服务〉
 *
 * @author amu
 * @create 2018/5/22
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteReadStageTeacherService {

    /**
     * 保存期数老师
     *
     * @param readStageTeacherDTO
     * @return
     */
    int save(ReadStageTeacherDTO readStageTeacherDTO);

    /**
     * 根据期数ID查询老师微信
     *
     * @param stageId
     * @return
     */
    List<ReadStageTeacherDTO> findByStageId(Long stageId);

}
