package cn.yoofans.knowledge.center.api.util;

import java.util.HashMap;
import java.util.Map;

/**
 * url参数解析
 *
 * @author qiuyp
 */
public class UrlUtils {

    /**
     * 解析url中所携带的参数
     *
     * @param URL
     * @return
     */
    public static Map<String, String> handUrlParams(String URL) {
        Map<String, String> mapRequest = new HashMap<String, String>();

        String[] arrSplit = null;

        String strUrlParam = truncateUrl(URL);
        if (strUrlParam == null) {
            return mapRequest;
        }
        arrSplit = strUrlParam.split("[&]");
        for (String strSplit : arrSplit) {
            String[] arrSplitEqual = null;
            arrSplitEqual = strSplit.split("[=]");

            //解析出键值
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);

            } else {
                if (arrSplitEqual[0] != "") {
                    mapRequest.put(arrSplitEqual[0], "");
                }
            }
        }
        return mapRequest;
    }

    /**
     * 去掉url中的路径
     *
     * @param strURL url地址
     * @return url请求参数部分
     */
    public static String truncateUrl(String strURL) {
        String strAllParam = null;

        strURL = strURL.trim();

        String[] arrSplit = strURL.split("[?]");
        if (strURL.length() > 1) {
            if (arrSplit.length > 1) {
                if (arrSplit[1] != null) {
                    strAllParam = arrSplit[1];
                }
            }
        }
        return strAllParam;
    }

}
