package cn.yoofans.knowledge.center.api.enums.coupon;

/**
 * 批量生产的优惠券状态枚举
 * @author zhanghuifeng
 * @date 2018/8/9下午8:44
 */
public enum BatchGrantCouponStateEnum {

    NOT_RECEIVE(1, "未领取"),
    RECEIVED(2, "已领取");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    BatchGrantCouponStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static BatchGrantCouponStateEnum getByCode(Integer code) {
        for (BatchGrantCouponStateEnum enumVal : BatchGrantCouponStateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
