package cn.yoofans.knowledge.center.api.enums.sns;

import java.util.Objects;

/**
 * 上传文件状态枚举
 * Created by qiuyp
 */
public enum SnsFileDetailStatusEnum {

    UN_PROCESS(0, "未处理"),

    PROCESSING(0, "处理中"),

    PROCESSED(2, "处理完");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    SnsFileDetailStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static SnsFileDetailStatusEnum getByCode(Integer code) {
        for (SnsFileDetailStatusEnum value : SnsFileDetailStatusEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
