package cn.yoofans.knowledge.center.api.enums.sns;

import java.util.Objects;

/**
 * 朋友圈文件处理状态枚举
 * Created by qiuyp
 */
public enum SnsFileProcessStatusEnum {
    UN_PROCESS(0, "未处理"),

    PROCESSING(1, "处理中"),

    PROCESS_SUCCESS(2, "处理成功"),

    PROCESS_FAIL(3, "处理失败");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    SnsFileProcessStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static SnsFileProcessStatusEnum getByCode(Integer code) {
        for (SnsFileProcessStatusEnum value : SnsFileProcessStatusEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
