/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemotePageComponentService
 * Author:   amu
 * Date:     2018/4/15 下午3:32
 * Description: 页面组件服务
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.PageComponentDTO;
import com.alibaba.fastjson.JSONArray;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈页面组件服务〉
 *
 * @author amu
 * @create 2018/4/15
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemotePageComponentService {

    /**
     * 按照ID查找组件
     * @param id
     * @return
     */
    PageComponentDTO findById(Long id);

    /**
     * 按照pageId查询组件集合
     * @param pageId
     * @return
     */
    List<PageComponentDTO> findByPageId(Long pageId);

    /**
     * 获取组件内容集合
     * @param type
     * @param pageComponentId
     * @param userId
     * @return
     */
    JSONArray floorData(String type,Long pageComponentId,Long userId);
}
