package cn.yoofans.knowledge.center.api.remoteservice.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.card.GiftCardDto;
import cn.yoofans.knowledge.center.api.param.billboard.BillBoardPageParam;
import cn.yoofans.knowledge.center.api.param.card.GiftCardPageParam;
import org.springframework.data.domain.PageImpl;

import java.util.List;

@AdvancedFeignClient
public interface RemoteGiftCardService {

    Boolean deleteById(Long id);

    Long save(GiftCardDto entity);

    GiftCardDto selectById(Long id);

    /**
     * 分页查询
     */

    PageImpl<GiftCardDto> pageByQuery(GiftCardPageParam pageParam);

    /**
     * 通过id批量查询
     */
    List<GiftCardDto> selectByIds(List<Long> ids);

    /**
     * 更新卡券状态
     */
    Boolean updateState(Long id,Integer cardState);

}